<?php /* Template Name: Learn to Swim */ ?>
<?php get_header('internal'); ?>
	<section class="mast">
		<div class="container">
			<div class="headline">
				<h1>Swimming...</h1>
				<h1>A Skill For Life</h1>			
			</div><!--headline-->
    	</div><!--container-->
	</section><!--hero-->
	<section class="content container">
		<section class="inside-container">
			<div class="single-col center">
				<div class="inside-container switch">
					<div class="circle">
						<img src="<?php bloginfo('template_directory'); ?>/img/learn-to-swim.png" width="400" height="400" alt=""/>
					</div><!--circle-->		
					<?php if(have_posts()) : while(have_posts()) : the_post(); ?>
						<h1><?php the_title(); ?></h1> 
						<?php the_content(); ?>
					<?php endwhile; ?>
					<?php endif; ?>	
					<?php wp_reset_query(); ?>		
				</div><!--inside-container-->	
			</div><!--single-col-->	
			<img class="divider" src="<?php bloginfo('template_directory'); ?>/img/divide-big.png" width="1193" height="4" alt=""/>
				<ul class="instructions">
					<li>To find out which class is best for you, please <italic>click</italic> on the class name below.<br>
					You will also be advised of class times. Simply <italic>reclick</italic> on the icon to hide.</li>
					<li>Please note : Class prices vary so feel free to <a href="mailto:enquiries@largsbayswimcentre.com.au">contact us</a> for further details.</li>
				</ul>
			<img class="divider" src="<?php bloginfo('template_directory'); ?>/img/divide-big.png" width="1193" height="4" alt=""/>
			<?php query_posts( array('cat' => 5))?>
			<?php if(have_posts()) : while(have_posts()) : the_post(); ?>	
				<div class="two-col swim-class lane-container">
					<a class="lane-header">
						<span class="tile" style="background:<?php the_field('class-colour'); ?> url('<?php the_field('class-img'); ?>') no-repeat center; 
						background-size:cover;"></span>						
						<span>
							<h3 style="color:<?php the_field('class-colour'); ?>"><?php the_title(); ?></h3>
							<p><?php the_field('ages'); ?></p>
						</span>
					</a>
					<div class="expand">
						<div class="col">
							<?php the_field('class-description'); ?>
							<div class="duration">
								<a style="color:<?php the_field('class-colour'); ?>">duration</a>
								<span><?php the_field('duration'); ?></span>
							</div><!--duration-->					
						</div><!--col-->
						<div class="col">
							<div class="container">
								<table style="background:<?php the_field('class-colour'); ?>">
									<tbody>	
										<?php if( get_field('mon-1') ): ?>
										<tr>
											<td>monday</td>
											<td><?php the_field('mon-1'); ?></td>
										</tr>
										<?php endif; ?>
										<?php if( get_field('mon-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('mon-2'); ?></td>
										</tr>
										<?php endif; ?>
										<?php if( get_field('tue-1') ): ?>
										<tr>
											<td>tuesday</td>
											<td><?php the_field('tue-1'); ?></td>
										</tr>
										<?php endif; ?>
										<?php if( get_field('tue-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('tue-2'); ?></td>
										</tr>
										<?php endif; ?>
										<?php if( get_field('wed-1') ): ?>
										<tr>
											<td>wednesday</td>
											<td><?php the_field('wed-1'); ?></td>
										</tr>
										<?php endif; ?>
										<?php if( get_field('wed-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('wed-2'); ?></td>
										</tr>
										<?php endif; ?>		
										<?php if( get_field('thu-1') ): ?>
										<tr>
											<td>thursday</td>
											<td><?php the_field('thu-1'); ?></td>
										</tr>
										<?php endif; ?>		
										<?php if( get_field('thu-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('thu-2'); ?></td>
										</tr>
										<?php endif; ?>		
										<?php if( get_field('fri-1') ): ?>
										<tr>
											<td>friday</td>
											<td><?php the_field('fri-1'); ?></td>
										</tr>
										<?php endif; ?>		
										<?php if( get_field('fri-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('fri-2'); ?></td>
										</tr>
										<?php endif; ?>										
										<?php if( get_field('sat-1') ): ?>
										<tr>
											<td>saturday</td>
											<td><?php the_field('sat-1'); ?></td>
										</tr>
										<?php endif; ?>											
										<?php if( get_field('sat-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('sat-2'); ?></td>
										</tr>
										<?php endif; ?>											
										<?php if( get_field('sun-1') ): ?>
										<tr>
											<td>sunday</td>
											<td><?php the_field('sun-1'); ?></td>
										</tr>
										<?php endif; ?>	
										<?php if( get_field('sun-2') ): ?>
										<tr>
											<td></td>
											<td><?php the_field('sun-2'); ?></td>
										</tr>
										<?php endif; ?>
									</tbody>	
								</table>
							</div><!--container-->
						</div><!--col-->
					</div><!--expand-->	
				</div><!--two-col-->
				<img class="lane" src="<?php bloginfo('template_directory'); ?>/img/lane.png" width="618" height="12" alt=""/>				
			<?php endwhile; ?>
			<?php endif; ?>				
		</section><!--inside-container-->
	</section><!--content-->
	<section class="banner">
		<section class="container">	
			<div class="inside-container">
			</div><!--inside-container-->	
		</section>
	</section><!--content-->
	<section class="tables container">
		<section class="inside-container">
		<section class="three-col left">
			<div class="col">
				<div class="container">
					<h3>centre opening hours</h3>
					<div class="circle">
						<img src="<?php bloginfo('template_directory'); ?>/img/opening.png" width="300" height="300" alt=""/>
					</div><!--circle-->
					<table>
						<tbody>
							<tr>
								<td>monday</td>
								<td>5.00am - 9.00pm</td>
							</tr>
							<tr>
								<td>tuesday</td>
								<td>5.00am - 9.00pm</td>
							</tr>						
							<tr>
								<td>wednesday</td>
								<td>6.00am - 9.00pm</td>
							</tr>
							<tr>
								<td>thursday</td>
								<td>5.00am - 8.30pm</td>
							</tr>
							<tr>
								<td>friday</td>
								<td>5.00am - 3.00pm</td>
							</tr>						
							<tr>
								<td>saturday</td>
								<td>12.00pm - 2.00pm</td>
							</tr>	
							<tr>
								<td>sunday*</td>
								<td>9.00am - 11.30pm</td>
							</tr>						
						</tbody>	
					</table>
					<small>*no lap | public swimming on sunday</small>
				</div><!--container-->	
				<a href="#" class="info-box">
					Please visit our Facebook page for public | school holiday opening times and latest updates				
				</a><!--info-box-->
			</div><!--col-->
			<div class="col">
				<div class="container">
					<h3>classes | lap &amp; public swimming</h3>
					<div class="circle">
						<img src="<?php bloginfo('template_directory'); ?>/img/classes.png" width="300" height="300" alt=""/>
					</div><!--circle-->
					<table>
						<tbody>
							<tr>
								<td>our times vary on a daily basis</td>
							</tr>
							<tr>
								<td>please check our session times 
								from the options below</td>
							</tr>		
							<tr>
								<td>
									<a href="#">lap &amp; public swimming</a>
								</td>
							</tr>							
							<tr>
								<td>
									<a href="#">learn to swim</a>
								</td>
							</tr>
							<tr>
								<td>
									<a href="#">aqua aerobics</a>
								</td>
							</tr>
							<tr>
								<td>
									<a href="#">squad programme</a>
								</td>
							</tr>
						</tbody>	
					</table>
				</div><!--container-->	
				<a href="#" class="info-box">
					Please refer to our individual classes for session times &amp; pricing
				</a><!--info-box-->				
			</div><!--col-->			
			<div class="col">
				<div class="container">
					<h3>general admission prices</h3>
					<div class="circle">
						<img src="<?php bloginfo('template_directory'); ?>/img/prices.png" width="300" height="300" alt=""/>
					</div><!--circle-->
					<table>
						<tbody>
							<tr>
								<td>casual &amp; pass prices</td>
								<td>concession</td>
							</tr>	
						</tbody>
					</table>						
					<table class="prices">
						<tbody>					
							<tr>
								<td>casual</td>
								<td>$7.00</td>
								<td>$6.00</td>
							</tr>						
							<tr>
								<td>10 visit pass</td>
								<td>$60.00</td>
								<td>$55.00</td>
							</tr>
							<tr>
								<td>20 visit pass</td>
								<td>$100.00</td>
								<td>$90.00</td>  						
							</tr>
							<tr>
								<td>monthly pass</td>
								<td>$65.00</td>
								<td>$60.00</td>  						
							</tr>						
							<tr>
								<td>6 month pass</td>
								<td>$274.00</td>
								<td>$260.00</td>
							</tr>					
						</tbody>	
					</table>
					<table>
						<tbody>
						<tr>
    						<td>children under 3</td>
    						<td>FREE</td>
  						</tr>	
						<tr>
    						<td>children over 3</td>
    						<td>CONCESSION</td>
  						</tr>						
					</tbody>
					</table>						
				</div><!--container-->	
				<a href="#" class="info-box">
					Children under 12 MUST BE ACCOMPANIED BY AN ADULT	
				</a><!--info-box-->
			</div><!--col-->			
		</section><!--three-col-->
		</section><!--inside-container-->
	</section><!--tables--->
<?php get_footer(); ?>