<!doctype html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title><?php bloginfo('name'); ?><?php wp_title('|'); ?></title>
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_directory'); ?>/css/animate.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>"/>
<link href='https://fonts.googleapis.com/css?family=Lato:400,700' rel='stylesheet' type='text/css'>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/src/scripts.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/src/jquery.sticky.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/src/jquery.leanModal.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/src/wow.js"></script>
<script>
	$(function() {
		$('a[rel*=leanModal]').leanModal({ top : 0, closeButton: ".modal_close" });
	});
</script>
<script>
	wow = new WOW(
		{
		boxClass:     'wow',    	// default
		animateClass: 'animated',	// default
		offset:       50,        	// default
		mobile:       true,     	// default  
		live:         true      	// default
		}
	)
	wow.init();
</script>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div id="mob-menu">
		<div class="menu-wrapper">
			<img class="logo alt" src="<?php bloginfo('template_directory'); ?>/img/logo-alt.svg" alt="Largs Bay Swim Centre"/>			
			<a class="modal_close"></a>
			<ul>
				<?php
				$defaults = array(
					'container'		=>	'',
					'menu'			=>	'overlay',
					'items_wrap'	=>	'%3$s'
				);
				wp_nav_menu( $defaults );
				?>
			</ul>
			<ul class="four-col">
				<li><a href="<?php the_field('learn-to-swim',219); ?>"></a></li>
				<?php query_posts( array('cat' => 5))?>
				<?php if(have_posts()) : while(have_posts()) : the_post(); ?>	
					<li>
						<a href="<?php the_field('learn-to-swim',219); ?>"></a>
					</li>
				<?php endwhile; ?>
				<?php endif; ?>	
				<?php wp_reset_query(); ?>
			</ul>
		</div><!--menu-wrapper-->			
	</div><!--mob-menu-->
	<div class="header-mob mobile">
		<div class="icons">
			<a href="<?php the_field('home',219); ?>" class="home-link"><img class="logo" src="<?php bloginfo('template_directory'); ?>/img/logo-alt.svg" alt="Largs Bay Swim Centre"/></a>
			<a id="go" href="#mob-menu" rel="leanModal"><img src="<?php bloginfo('template_directory'); ?>/img/hamburger.svg" alt="menu"/></a>		
		</div><!--icons-->
	</div><!--mobile-->	
	<section class="header desktop">
		<div class="top-bar">
			<div class="trans-bg">	
				<div class="container">	
					<a class="main-logo-link" href="<?php bloginfo('url'); ?>"><img class="logo alt" src="<?php bloginfo('template_directory'); ?>/img/logo-alt.svg" alt="Largs Bay Swim Centre"/></a>
					<div class="icons">
							<a href="tel:+618<?php the_field('phone',219); ?>">
								<img src="<?php bloginfo('template_directory'); ?>/img/footer-phone.svg" alt="Phone:"/>
								<span>(08) <?php the_field('phone',219); ?></span>
							</a>
							<a>
								<img src="<?php bloginfo('template_directory'); ?>/img/footer-address.svg" alt="Address:"/>
								<span>195 Victoria Road Largs Bay SA 5016</span>
							</a>				
							<a href="<?php the_field('facebook',219); ?>"><img src="<?php bloginfo('template_directory'); ?>/img/footer-fb.svg" alt="Facebook"/></a>
							<a href="mailto:<?php the_field('email',219); ?>"><img src="<?php bloginfo('template_directory'); ?>/img/footer-email.svg" alt="Email"/></a>
					</div><!--icons-->
				</div><!--container-->
			</div><!--trans-bg-->
			<div class="nav-bar sticker">	
				<div class="container">	
					<img class="logo alt" src="<?php bloginfo('template_directory'); ?>/img/logo-alt.svg" alt="Largs Bay Swim Centre"/>
					<ul class="nav">
						<?php
						$defaults = array(
							'container'		=>	'',
							'menu'			=>	'menu',
							'items_wrap'	=>	'%3$s'
						);
						wp_nav_menu( $defaults );
						?>
					</ul><!--nav-->	
					<div class="mm-btn-container">
						<a class="mmenu" href="#mob-menu" name="mob-menu" rel="leanModal" >
							Menu <img src="<?php bloginfo('template_directory'); ?>/img/hamburger-alt.svg" alt="menu"/>
						</a>
					</div><!--mm-btn-container-->																
				</div><!--container-->
				<div class="clearfix"></div>
			</div><!--nav-bar-->
		</div><!--top-bar-->
	</section><!--header-->